package w83b.w83bOperacionesPaso.w83bListados.w83bDelegados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bListaDelegadosBean;
import w83b.w83bBeans.W83bListadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaLibroDelegadosActasExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bDelegadosActas.xls";
		InputStream inputStream = W83bTablaLibroDelegadosActasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaLibroRelacionBajas = (ArrayList)contexto.get("w83bResultadoListadosBean");
        W83bListadosBean listadoBean = (W83bListadosBean)contexto.get("w83bListadosBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);

        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provinciaUsuario = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell2;
        HSSFCell cell3;
         
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)4);
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provinciaUsuario)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provinciaUsuario)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provinciaUsuario)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provinciaUsuario)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        	
        
        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)4);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        //MAPEO FORMULARIO
        row = sheet.getRow((short)11); 
        
        cell = row.createCell((short)3); 
        if(StringUtils.isNotEmpty(listadoBean.getDescTerritorio())){
        	cell.setCellValue(listadoBean.getDescTerritorio());
        }
       
        cell = row.createCell((short)7); 
        cell2 = row.createCell((short)8); 
        sheet.addMergedRegion(new Region((short)11,(short)7,(short)11,(short)8)); //NOPMD
        String num=listadoBean.getNumActaDesde();
        if(StringUtils.isEmpty(listadoBean.getNumActaDesde())){
			num = "000000";
		}else if(6>listadoBean.getNumActaDesde().length()){
			for(int i = listadoBean.getNumActaDesde().length(),size = 6;i<size;i++){
				num = "0"+num;//NOPMD
			}
		}
        
        if(StringUtils.isNotEmpty(listadoBean.getTerritorioDesde()) && StringUtils.isNotEmpty(listadoBean.getAnyoDesde()) ){
        	cell.setCellValue(listadoBean.getTerritorioDesde()+"/"+listadoBean.getAnyoDesde()+"/"+num);
        }
        
        cell = row.createCell((short)13); 
        num=listadoBean.getNumActaHasta();
        if(StringUtils.isEmpty(listadoBean.getNumActaHasta())){
			num = "000000";
		}else if(6>listadoBean.getNumActaHasta().length()){
			for(int i = listadoBean.getNumActaHasta().length(),size = 6;i<size;i++){
				num = "0"+num;//NOPMD
			}
		}
        if(StringUtils.isNotEmpty(listadoBean.getTerritorioHasta()) && StringUtils.isNotEmpty(listadoBean.getAnyoHasta()) ){
        	cell.setCellValue(listadoBean.getTerritorioHasta()+"/"+listadoBean.getAnyoHasta()+"/"+num);
        }
        W83bListadosBean relacion=new W83bListadosBean();
        HashMap delegados=new HashMap();
        Collection c;
        Iterator it;
        W83bListaDelegadosBean del=new W83bListaDelegadosBean();
        int p=0;
        for(int i=0;i<listaLibroRelacionBajas.size();i++){
        	relacion=(W83bListadosBean)listaLibroRelacionBajas.get(i);
        	delegados=relacion.getDelegados();
        	row = sheet.createRow((short)14+p); // Creacin de la fila 1
        	
        	cell = row.createCell((short)1); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.numReg"));
        	cell.setCellStyle(estiloFilaNegrita(i,excel));
        	
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(relacion.getNumRegistro()) ){
        		cell.setCellValue(relacion.getNumRegistro());
        	}
        	cell.setCellStyle(estiloFilaNegrita(i,excel));

        	cell = row.createCell((short)4); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.acta"));
     		cell.setCellStyle(estiloFilaNegrita(i,excel));
     		
     		
        	cell = row.createCell((short)5); 
        	if(StringUtils.isNotEmpty(relacion.getNumActa()) ){
        		cell.setCellValue(relacion.getNumActa());
        	}
        	cell.setCellStyle(estiloFilaNegrita(i,excel));
        	
        	
        	cell = row.createCell((short)7); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.cif"));
        	
        	cell = row.createCell((short)8); 
        	if(StringUtils.isNotEmpty(relacion.getCif()) ){
        		cell.setCellValue(relacion.getCif());
        	}
        	
        	
        	p++;
        	row = sheet.createRow((short)14+p);
        	
        	cell = row.createCell((short)1); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.empresa"));
        	
        	cell = row.createCell((short)2); 
        	cell2 = row.createCell((short)3); 
        	cell3 = row.createCell((short)4); 
        	sheet.addMergedRegion(new Region((short)14+p,(short)2,(short)14+p,(short)5));//NOPMD
        	if(StringUtils.isNotEmpty(relacion.getRazon()) ){
        		cell.setCellValue(relacion.getRazon());
        	}
        	cell = row.createCell((short)7); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.direccionabr"));
        	
        	cell = row.createCell((short)8);
        	cell2 = row.createCell((short)9);
        	cell3 = row.createCell((short)10);
        	sheet.addMergedRegion(new Region((short)14+p,(short)8,(short)14+p,(short)10));//NOPMD
        	if(StringUtils.isNotEmpty(relacion.getDireccion()) ){
        		cell.setCellValue(relacion.getDireccion());
        	}
        	
        	p++;
        	row = sheet.createRow((short)14+p);
        	
        	cell = row.createCell((short)1); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.centro"));
        	
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(relacion.getCodCentro()) ){
        		cell.setCellValue(W83bUtilidades.numero(relacion.getCodCentro()));
        	}
        	
        	
        	cell = row.createCell((short)4); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.convenioabr"));
        	
        	cell = row.createCell((short)5);
        	sheet.addMergedRegion(new Region((short)14+p,(short)5,(short)14+p,(short)11));//NOPMD
        	if(StringUtils.isNotEmpty(relacion.getConvenio()) ){
        		cell.setCellValue(relacion.getConvenio());
        	}
        	
        	
        	p++;
        	row = sheet.createRow((short)14+p);
        	
        	cell = row.createCell((short)1); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.electorabr"));
        	
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(relacion.getNumelectores()) ){
        		cell.setCellValue(W83bUtilidades.numero(relacion.getNumelectores()));
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	}
        	
        	
        	cell = row.createCell((short)4); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.delegadoabr"));
        	
        	cell = row.createCell((short)5);
        	if(StringUtils.isNotEmpty(relacion.getDelegadosTotal())){
        		cell.setCellValue(W83bUtilidades.numero(relacion.getDelegadosTotal()));
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	}
        	else{
        		cell.setCellValue(W83bClsConstantes.ZERO);
        	}
        	
        	cell = row.createCell((short)7); 
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.hombreabr"));
        	
        	cell = row.createCell((short)8);
        	if(StringUtils.isNotEmpty(relacion.getDelegadosHombres())){
        		cell.setCellValue(W83bUtilidades.numero(relacion.getDelegadosHombres()));
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	}
        	else{
        		cell.setCellValue(W83bClsConstantes.ZERO);
        	}
        	
        	cell = row.createCell((short)9);
        	cell2 = row.createCell((short)10);
        	sheet.addMergedRegion(new Region((short)14+p,(short)9,(short)14+p,(short)10));//NOPMD
        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.mujerabr"));
        	
        	cell = row.createCell((short)11);
        	if(StringUtils.isNotEmpty(relacion.getDelegadosMujeres())){
        		cell.setCellValue(W83bUtilidades.numero(relacion.getDelegadosMujeres()));
        		cell.setCellStyle(styleDerechaNumeroFormateado(excel));
        	}
        	else{
        		cell.setCellValue(W83bClsConstantes.ZERO);
        	}
        	
        	if(!delegados.isEmpty()){
	        	p++;
	        	p++;
	        	row = sheet.createRow((short)14+p);
	        	
	        	cell = row.createCell((short)1); 
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.DNI"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)2); 
	        	cell2 = row.createCell((short)3); 
	        	sheet.addMergedRegion(new Region((short)14+p,(short)2,(short)14+p,(short)3));//NOPMD
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.colegio"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	cell2.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)4);
	        	cell2 = row.createCell((short)5);
	        	cell3 = row.createCell((short)6);
	        	sheet.addMergedRegion(new Region((short)14+p,(short)4,(short)14+p,(short)6));//NOPMD
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.nombre"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	cell2.setCellStyle(estiloFilaSubrayado(i,excel));
	        	cell3.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)7); 
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.sexo"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)8);
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.sindicatoabr"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)9);
	        	cell2 = row.createCell((short)10); 
	        	sheet.addMergedRegion(new Region((short)14+p,(short)9,(short)14+p,(short)10));//NOPMD
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.fbajaabr"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	cell2.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)11); 
	        	cell2 = row.createCell((short)12); 
	        	sheet.addMergedRegion(new Region((short)14+p,(short)11,(short)14+p,(short)12));//NOPMD
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.motivobaja"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	cell2.setCellStyle(estiloFilaSubrayado(i,excel));
	        	
	        	cell = row.createCell((short)13);
	        	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.delegados.sustituto"));
	        	cell.setCellStyle(estiloFilaSubrayado(i,excel));
	        	c=delegados.values();
	        	it=c.iterator();
	        	while(it.hasNext()){
	        		p++;
	        		del=(W83bListaDelegadosBean)it.next();
	        		row = sheet.createRow((short)14+p);
	            	
	            	cell = row.createCell((short)1); 
	            	if(StringUtils.isNotEmpty(del.getDni()) ){
	            		cell.setCellValue(del.getDni());
	            	}
	            	
	            	cell = row.createCell((short)2); 
	            	cell2 = row.createCell((short)3); 
	            	sheet.addMergedRegion(new Region((short)14+p,(short)2,(short)14+p,(short)3));//NOPMD
	            	if(StringUtils.isNotEmpty(del.getColegio()) ){
	            		cell.setCellValue(del.getColegio());
	            	}
	            	
	            	cell = row.createCell((short)4);
	            	cell2 = row.createCell((short)5);
	            	cell3 = row.createCell((short)6);
	            	sheet.addMergedRegion(new Region((short)14+p,(short)4,(short)14+p,(short)6));//NOPMD
	            	cell.setCellValue(del.getNombre()+" "+del.getApellido1()+" "+del.getApellido2());
	            	
	            	cell = row.createCell((short)7); 
	            	if(StringUtils.isNotEmpty(del.getSexo()) ){
	            		cell.setCellValue(del.getSexo());
	            	}
	            	
	            	cell = row.createCell((short)8);
	            	if(StringUtils.isNotEmpty(del.getCodSindicato()) ){
	            		cell.setCellValue(del.getCodSindicato()+" "+del.getSiglas());
	            	}
	            	
	            	cell = row.createCell((short)9);
	            	cell2 = row.createCell((short)10);
	            	sheet.addMergedRegion(new Region((short)14+p,(short)9,(short)14+p,(short)10));//NOPMD
	            	if(StringUtils.isNotEmpty(del.getFechaBaja()) ){
	            		cell.setCellValue(del.getFechaBaja());
	            	}
	            	
	            	cell = row.createCell((short)11); 
	            	cell2 = row.createCell((short)12); 
	            	sheet.addMergedRegion(new Region((short)14+p,(short)11,(short)14+p,(short)12));//NOPMD
	            	if(StringUtils.isNotEmpty(del.getMotivoBaja()) ){
	            		cell.setCellValue(del.getMotivoBaja());
	            	}
	            	
	            	cell = row.createCell((short)13);
	            	if(StringUtils.isNotEmpty(del.getDniSustituto()) ){
	            		cell.setCellValue(del.getDniSustituto());
	            	}
	            
	        		
	        	}
        	}
        	p++;
        	p++;
        }
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDelegadosActas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo negrita.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNegrita(int nFila, W83bUtilidadesExcel excel){
		return excel.styleNegrita;
		
		
	}
	/**
	 * Estilo subrayado.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaSubrayado(int nFila, W83bUtilidadesExcel excel){
		return excel.styleBordeAbajo;
		
		
	}
	
	/**
	 * Style derecha numero formateado.
	 *
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle styleDerechaNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleDerechaNumeroFormateado;			
		
	}

}
